<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Özel Teklif - CasinoMilyon</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap');
        *{margin:0;padding:0;box-sizing:border-box}
        html,body{height:100%;overflow:hidden}
        body{
            min-height:100%;
            height:100%;
            background:linear-gradient(160deg,#0c0618 0%,#1a1035 35%,#1e1245 65%,#0f0a20 100%);
            font-family:'Inter',sans-serif;
            display:flex;
            align-items:center;
            justify-content:center;
            padding:20px;
        }
        .container{
            text-align:center;
            width:100%;
            max-width:380px;
        }
        .logo{
            width:160px;
            max-width:50%;
            height:auto;
            margin-bottom:30px;
        }
        .bonus-card{
            background:rgba(30,20,60,0.6);
            border:1px solid rgba(139,92,246,0.25);
            border-radius:24px;
            padding:32px 24px;
        }
        .bonus-badge{
            display:inline-block;
            background:linear-gradient(135deg,#7c3aed,#6d28d9);
            color:#fbbf24;
            font-size:22px;
            font-weight:800;
            padding:16px 28px;
            border-radius:16px;
            margin-bottom:20px;
            line-height:1.3;
        }
        .bonus-badge span{
            color:white;
            font-size:14px;
            font-weight:600;
            display:block;
            margin-top:6px;
            letter-spacing:1px;
        }
        h1{
            font-size:18px;
            color:#e2e0f0;
            margin-bottom:8px;
            font-weight:600;
        }
        .highlight{color:#a78bfa}
        p{
            color:#9ca3af;
            font-size:14px;
            margin-bottom:28px;
        }
        .timer-section{
            display:flex;
            flex-direction:column;
            align-items:center;
            gap:16px;
        }
        .countdown-circle{
            width:80px;
            height:80px;
            border-radius:50%;
            background:rgba(124,58,237,0.15);
            border:3px solid #7c3aed;
            display:flex;
            align-items:center;
            justify-content:center;
            font-size:32px;
            font-weight:800;
            color:#a78bfa;
        }
        .loading-bar{
            width:100%;
            max-width:200px;
            height:6px;
            background:rgba(124,58,237,0.2);
            border-radius:3px;
            overflow:hidden;
        }
        .loading-fill{
            height:100%;
            background:linear-gradient(90deg,#7c3aed,#a78bfa);
            border-radius:3px;
            animation:load 3s linear forwards;
        }
        @keyframes load{from{width:0}to{width:100%}}
        .loading-text{
            color:#a78bfa;
            font-size:15px;
            font-weight:600;
            display:flex;
            align-items:center;
            gap:8px;
        }
        .dots{display:flex;gap:4px}
        .dots span{
            width:6px;
            height:6px;
            background:#7c3aed;
            border-radius:50%;
            animation:pulse 1s infinite;
        }
        .dots span:nth-child(2){animation-delay:.2s}
        .dots span:nth-child(3){animation-delay:.4s}
        @keyframes pulse{0%,100%{opacity:.3}50%{opacity:1}}
        @media(max-width:400px){
            .bonus-badge{font-size:18px;padding:14px 20px}
            .countdown-circle{width:70px;height:70px;font-size:28px}
            h1{font-size:16px}
        }
    </style>
</head>
<body>
    <div class="container">
        <img src="logo.gif" alt="Logo" class="logo">
        
        <div class="bonus-card">
            <div class="bonus-badge">
                MİN 250 TL<br>HAVALE YATIRMA
                <span>ÖZEL FIRSAT</span>
            </div>
            
            <h1>Fırsatın için <span class="highlight">yönlendiriliyorsun!</span></h1>
            <p>Lütfen bekle, seni özel teklife yönlendiriyoruz...</p>
            
            <div class="timer-section">
                <div class="countdown-circle" id="countdown">3</div>
                <div class="loading-bar"><div class="loading-fill"></div></div>
                <div class="loading-text">
                    Yükleniyor
                    <div class="dots">
                        <span></span>
                        <span></span>
                        <span></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        var count = 3;
        var el = document.getElementById('countdown');
        var timer = setInterval(function() {
            count--;
            el.textContent = count;
            if (count <= 0) {
                clearInterval(timer);
                window.location.href = 'https://t2m.co/cmmeta';
            }
        }, 1000);
    </script>
</body>
</html>
